#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 dirLight : register (c14);
float4x4 viewMatrix : register (c16);
float4x4 invViewMatrix : register (c20);

int4 numOmniLight : register (i0); // (count, init, stride, 0)
//int4 numSpotLight : register (i1); // (count, init, stride, 0)

float4 omniPosRad[64]   : register (c72);
float4 omniRGBDelta[64] : register (c136);

float4 spotPosRad[64]   : register (c72);
float4 spotDirCone[64]  : register (c136);
float4 spotRGBDelta[64] : register (c200);

struct VS_OUTPUT
{
   float4 Pos        : POSITION;
   float4 Diff       : COLOR0;
   float4 Omni       : COLOR1;
#ifdef USEFOG
   float  Fog        : FOG;
#endif   
   float2 Tex        : TEXCOORD0; // base
   float2 Bump       : TEXCOORD1; // specular map
   float2 SparkleTex : TEXCOORD2; // bump map
   float3 Tangent    : TEXCOORD3; // 
   float3 Binormal   : TEXCOORD4; // 
   float3 Normal     : TEXCOORD5; // 
   float3 Light      : TEXCOORD6; // tangent space light
   float3 EyeVec     : TEXCOORD7; // tangent space eye vec
};

VS_OUTPUT vs20_twoTonePaintT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex : TEXCOORD0, float2 inBump : TEXCOORD1, float2 inSparkle : TEXCOORD2)
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);
  float3 worldPos = mul (worldMatrix, inPos);

  float3 worldS;
  float3 worldT;
  float3 worldSxT;
  worldS = mul (worldMatrix, inTangent.xyz);
  worldT = mul (worldMatrix, inBiNorm.xyz);
  worldSxT = mul (worldMatrix, inNorm.xyz);

  Out.Tangent.x = worldS.x;
  Out.Tangent.y = worldT.x;
  Out.Tangent.z = worldSxT.x;
  Out.Binormal.x = worldS.y;
  Out.Binormal.y = worldT.y;
  Out.Binormal.z = worldSxT.y;
  Out.Normal.x = worldS.z;
  Out.Normal.y = worldT.z;
  Out.Normal.z = worldSxT.z;
  
  Out.Light = dirLight;
  Out.EyeVec = worldPos - invViewMatrix[3];
  
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  float3 eyeVec = (worldEye + worldPos.xyz);

#ifdef USEFOG
  // compute fog
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   

  // Compute omnilights
  Out.Omni = (0,0,0,0);
  for (int i=0; i<numOmniLight.x; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        Out.Omni.rgb += (sqrt(intens) * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  Out.Omni.rgb *= 0.5F;
  //else if (numSpotLight.x > 0)
  //{
  //  // Compute spotlights
  //  float4 spotColor = (0,0,0,0);
  //  float3 worldNorm = mul (worldMatrix, inNorm);
  //
  //  for (int i=0; i<numSpotLight.x; i++)
  //  {
  //    // check backface
  //    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
  //    {
  //      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
  //      float mag = dot (spotToVert.xyz, spotToVert.xyz);
  //      // check if vert in range
  //      if (mag < spotPosRad[i].w) // using square distances
  //      {
  //        // check if vert in cone
  //        mag = dot (normalize(spotToVert.xyz), spotDirCone[i].xyz);
  //        if (mag > spotDirCone[i].w)
  //        {
  //          float intensity = (1.0F - ( mag * spotRGBDelta[i].w));
  //          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
  //        }  
  //      }
  //    }
  //  }
  //  Out.Omni = spotColor;
  //}

  // Propagate color and texture coordinates:
  Out.Diff = inColor;
  Out.Tex  = inTex;
  Out.Bump = inBump;
  Out.SparkleTex = inSparkle;

  return (Out);
}

